<?php

function restletBaseString($httpMethod, $url, $consumerKey, $tokenKey, $nonce, $timestamp, $version, $signatureMethod, $postParams){
  //http method must be upper case
  $baseString = strtoupper($httpMethod) .'&';

  //include url without parameters, schema and hostname must be lower case
  if (strpos($url, '?')){
    $baseUrl = substr($url, 0, strpos($url, '?'));
    $getParams = substr($url, strpos($url, '?') + 1);
  } else {
   $baseUrl = $url;
   $getParams = "";
  }
  $hostname = strtolower(substr($baseUrl, 0,  strpos($baseUrl, '/', 10)));
  $path = substr($baseUrl, strpos($baseUrl, '/', 10));
  $baseUrl = $hostname . $path;
  $baseString .= rawurlencode($baseUrl) .'&';

  //all oauth and get params. First they are decoded, next sorted in alphabetical order, next each key and values is encoded and finally whole parameters are encoded
  $params = array();
  $params['oauth_consumer_key'] = array($consumerKey);
  $params['oauth_token'] = array($tokenKey);
  $params['oauth_nonce'] = array($nonce);
  $params['oauth_timestamp'] = array($timestamp);
  $params['oauth_signature_method'] = array($signatureMethod);
  $params['oauth_version'] = array($version);

  foreach (explode('&', $getParams ."&". $postParams) as $param) {
    $parsed = explode('=', $param);
    if ($parsed[0] != "") {
      $value = isset($parsed[1]) ? urldecode($parsed[1]): "";
      if (isset($params[urldecode($parsed[0])])) {
        array_push($params[urldecode($parsed[0])], $value);
      } else {
        $params[urldecode($parsed[0])] = array($value);
      }
    }
  }

  //all parameters must be sorted in alphabetical order
  ksort($params);

  $paramString = "";
  foreach ($params as $key => $valueArray){
    //all values must sorted in alphabetical order
    sort($valueArray);
    foreach ($valueArray as $value){
      $paramString .= rawurlencode($key) . '='. rawurlencode($value) .'&';
    }
  }
  $paramString = substr($paramString, 0, -1);
  $baseString .= rawurlencode($paramString);
  return $baseString;
}

$url = 'https://6392137-sb1.suitetalk.api.netsuite.com/services/rest/query/v1/suiteql';
$httpMethod = 'POST';
$tokenKey = 'a8e9c75046abf91ca8b92a22b69acfc6b9c54c549c49a5ee953f3ed97d5d9bb2';
$consumerKey = '9b3733170160f54cabb5c44e6ffcb9fc8d5ca75a7113babbbe8c96b2c041237c';
$signatureMethod = 'HMAC-SHA256';     //or HMAC-SHA1 or PLAINTEXT
$nonce     = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 20);
$timestamp = time();        //time();
$version = '1.0';

$consumerSecret = "2c668be03323d47afe8a61be1f421dea26da26cc3f124f86c36e56fa22b8f175";

$tokenSecret = "6e5b56f91a58fd5fcd0f89a070655dfd6699d0221183e0227e7983dedf1b1a2a";

 $baseString = restletBaseString($httpMethod, $url, $consumerKey,  $tokenKey,$nonce,$timestamp,$version,$signatureMethod,false);

$key = rawurlencode($consumerSecret) .'&'. rawurlencode($tokenSecret);

$signature = base64_encode(hash_hmac('sha256', $baseString, $key, true));

$header = 'Authorization: OAuth '
         .'realm="6392137_SB1", '
         .'oauth_token="' .rawurlencode($tokenKey) .'", '
         .'oauth_consumer_key="' .rawurlencode($consumerKey) .'", '
         .'oauth_nonce="' .rawurlencode($nonce) .'", '
         .'oauth_timestamp="' .rawurlencode($timestamp) .'", '
         .'oauth_signature_method="' .rawurlencode($signatureMethod) .'", '
         .'oauth_version="' .rawurlencode($version) .'", '
         .'oauth_signature="' .rawurlencode($signature) .'"';

var_dump($header);

 $curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://6392137-sb1.suitetalk.api.netsuite.com/services/rest/query/v1/suiteql',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
  "q": "SELECT * from classification"
}
// ',
CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'prefer: transient',
    'oauth_token: a8e9c75046abf91ca8b92a22b69acfc6b9c54c549c49a5ee953f3ed97d5d9bb2',
     $header,
  ),
));
//
$response = curl_exec($curl);

curl_close($curl);
echo $response;
