$(document).ready(function() {
    var dealerId = localStorage.getItem("dealerId");
    var username = localStorage.getItem("username");
    var dealerName = localStorage.getItem("dealername");
    $('#dealer-name').text(dealerName);
    const params = new URLSearchParams(window.location.search);
    const sku = params.get("sku");
    if (dealerId && username) {
        var token = get_accesstoken();
        get_product_details(username,dealerId,sku);
    } else {
        window.location.replace("login.html");
    }
});

/**
 * To get the access token dynamically
 */
 function get_accesstoken() {
    let token = "";
    $.ajax({
        url: `http://ctframework.cnetric.com:1880/createOAuthToken`,
        type: "POST",
        async: false,
        success: function(data) {
            if (data.length) {
                token = data.access_token;
            }
            console.log(data);
            token = data.access_token;
        }
    });
    return token;
}

$(".logout").click(function() {
    localStorage.removeItem('dealerId');
    localStorage.removeItem('username');
    localStorage.removeItem('dealername');
});

function get_stock(sku, dealerId) {
    $.ajax({
        url: `http://ctframework.cnetric.com:1880/get_inventory/${sku}/${dealerId}`,
        type: "GET",
        success: function(data) {
            console.log(data);
            if (data.length && data[0] !='null') {
                var data = data[0];
                let StockTxt = `<li class = "list-group-item item-stock" id="${sku}">Stock <span class="stock-quantity">${data.stock}</span><span  class="stock_edit" data-toggle="modal" data-target="#edit-stock" data-sku="${sku}" data-value="${data.stock}"><i class="fa fa-edit"></i></span></li>`;
                $('.product-details-list').append(StockTxt);
                $(function() {
                    $('.stock_edit').click(function() {
                        console.log("stock")
                        console.log($('#edit-stock'))
                        $('#edit-stock').attr('data-sku', $(this).attr('data-sku'));
                    });
                })
            }
        }
    });
}

function get_product_details(username,dealerId,sku) {
    $.ajax({
        url: `http://ctframework.cnetric.com:1880/get_dealer_product/${dealerId}/${sku}`,
        type: "GET",
        // headers: {
        //     "accessToken": token
        // },
        success: function(data) {
            let ProductTxt = `
                    <li class = "list-group-item">Name<span>${data[0].name}  </span></li>
                    <li class = "list-group-item">Sku<span> ${data[0].sku} </span></li>                   
                    `;
            $('.product-details-list').html(ProductTxt);


            let ProductTxt3 = `
                <li class="list-group-item">Description <span>${data[0].description}</span></li>
                <li class="list-group-item">Status <span>Published</span></li>`;
            $('.description_list').html(ProductTxt3);



            let priceTxt = `
            <li class="list-group-item">Total Amount(tax inclusive) <span>$ ${data[0].price}</span>
            <li class="list-group-item">Currency <span> ${data[0].currancy}</span>
            `;
            $('.information-details-list').html(priceTxt);



            let with_taxt = `
            <li class="list-group-item">Amount<span>${data[0].price}</span>
            <li class="list-group-item">Currency <span> ${data[0].currancy}</span>
            
            `;
            $('.with_tax_list').html(with_taxt);




            let without_taxt = `
            <li class="list-group-item"> Amount<span>${data[0].price}</span>
            <li class="list-group-item">Currency<span> ${data[0].currancy}</span>
            `;
            $('.without_tax_list').html(without_taxt);

            var src = data[0].image;
            $('#product_image').attr('src', src);


            $('#user-name').text(username);
            get_stock(data[0].sku,dealerId);
        }
    });
}

$('.update_stock').click(function() {
    var dealerId = localStorage.getItem("dealerId");
    edit_stock($("#edit-stock").attr('data-sku'), $("#Stock").val(),dealerId);
})

$(document).on('click', '.stock_edit', function() {
    $("#Stock").val($(this).attr('data-value'));
})

function edit_stock(sku, quantity, dealerId) {
    $.ajax({
        url: `http://ctframework.cnetric.com:1880/edit_inventory/${sku}/${quantity}/${dealerId}`,
        type: "PUT",
        data: {},
        success: function(data) {
            console.log(data);
            $('#edit-stock').modal('hide');
            $('#edit-stock').attr('data-sku', '');
            $('#Stock').val('');
            if(data.length>1 && data[1].changedRows){
                $('.item-stock').remove();
                get_stock(sku,dealerId);
                $.notify("Stock Update Successfully!!", { className: 'success', showDuration: 400, autoHideDelay: 2000, position: 'right bottom' });
            } 
            else if(data.changedRows){
                $('.item-stock').remove();
                get_stock(sku,dealerId);
                $.notify("Stock Update Successfully!!", { className: 'success', showDuration: 400, autoHideDelay: 2000, position: 'right bottom' });
            } else {
                $.notify("Stock Update Unsuccessfully!!", { className: 'error', showDuration: 400, autoHideDelay: 2000, position: 'right bottom' });
            }
        }
    });
}