<?php
include "db_connection.php";

// Query to fetch brands from the brands table
$sql = "SELECT id, brand_name,brand_image FROM brand";
$result = mysqli_query($conn, $sql);

// Check if there are brands
if (mysqli_num_rows($result) > 0) {
    // Output section start
    echo '<section class="section-adj" id="accordionBrand">
        <div class="container-fluid px-2 py-2">
            <div class="row">';
    error_log("Loading");
    // Loop through each brand and generate HTML
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<div class="col-md-12">
                <div class="card">
                    <div class="card-header collapsed edit-product-item-up" data-toggle="collapse" data-target="#collapseTwo_' . $row['id'] . '" aria-expanded="false">
                        <div class="d-flex pt-0 mt-0">
                            <div class="mr-3"><img src="' . $row['brand_image'] . '" style="width:40px;height:40px !important;border-radius: 50%;" /></div>
                            <div class="pt-2">
                                <p class="text-color-4C4C4C fw-500">' . $row['brand_name'] . '</p>
                            </div>
                            <div class="pt-1 ml-auto">
                                <span class="accicon ml-5 toggleClass" data-toggle="collapse" data-target="#collapseTwo_' . $row['id'] . '" aria-expanded="false" aria-controls="collapseTwo_' . $row['id'] . '">
                                <i class="fa fa-angle-down rotate-icon"></i></span>
                            </div>
                        </div>
                    </div>
                    <div id="collapseTwo_' . $row['id'] . '" class="collapse" data-parent="#accordionBrand"  style="">
                        <div class="card-body pl-5">
                        <div class="pt-1 mr-5 text-right"></div>
                        <div class="wrapper">
                          <div class="scrollbar">
                              <div class="force-overflow">
                                  <h3>'.$row['brand_name'].'</h3>';
                                
     // $product_sql = "SELECT name, sku, available, sellingPrice FROM products WHERE subCategory = '".$sub_row['sub_name']."'";
     $product_sql = "SELECT p.name as name, p.sku as sku, p.available as available, p.basePrice as basePrice, i.name as thumbnail 
    FROM products p 
  LEFT  JOIN images i ON p.id = i.product_id 
    WHERE p.vendorName = '".$row['brand_name']."'";
  error_log("loading product");
     $product_result = mysqli_query($conn, $product_sql);
      if ($product_result && mysqli_num_rows($product_result) > 0) {
          echo '<table class="datatable ml-5" style="width:100%">
                                      <thead>
                                          <tr>
                                              <th class="p-2 text-color-4C4C4C fw-500">Thumbnails</th>
                                              <th class="p-2 text-color-4C4C4C fw-500">Product Name</th>
                                              <th class="p-2 text-color-4C4C4C fw-500">SKU</th>
                                              <th class="p-2 text-color-4C4C4C fw-500">Stock</th>
                                              <th class="p-2 text-color-4C4C4C fw-500 pr-5">Price</th>
                                          </tr>
                                      </thead>
                                      <tbody>';
          while ($product_row = mysqli_fetch_assoc($product_result)) {
              echo '<tr>
                      <td class="p-2"><img src="uploads/'.$product_row['thumbnail'].'" style="width: 50px;"/></td>
                      <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['name'].'</td>
                      <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['sku'].'</td>
                      <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['available'].'</td>
                      <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['basePrice'].'</td>
                    </tr>';
                    error_log("Done");
          }
          echo '</tbody></table>';
          error_log("table");
      } else {
          echo '<p>No products found for this brand.</p>';
      }
      echo ' </div>
      </div>
    </div>
  </div>
</div></div></div>
         ';
    }
    
    // Output section end
    echo '</div>
        </div>
    </section>';
} else {
    // No brands found
    echo 'No brands found.';
}

// Close the database connection
mysqli_close($conn);
?>
<script>
    const toggles = document.querySelectorAll(".toggleClass");

toggles.forEach((toggle) => {
  toggle.addEventListener("click", () => {
    const targetId = toggle.getAttribute("data-target");
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                targetElement.classList.toggle("show");
            }
  });
});
</script>